#version 330
#extension GL_EXT_gpu_shader4 : enable
//columnas otro abcMod01.fsh  by   jorge2017a1
//https://www.shadertoy.com/view/Ws3yRs
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//prevoid common ---//

struct TObj
{
    float id_color;
    float id_objeto;
    float id_material;
    float dist;
    vec3 normal;
    vec3 ro;
    vec3 rd;
    vec2 uv;
    vec3 color;
    vec3 p;
    vec3 rf;
    float marchCount;
    bool blnShadow; 
};

    
TObj mObj;
vec3 glpRoRd;
vec2 gres2;
float itime;

#define PI 3.14159265358979323846264
#define PI2 6.28318530717
#define TriplePI (3.0 * PI)
#define DoublePI (2.0 * PI)
#define HalfPI (PI / 2.0)
#define MATERIAL_NO -1.0
#define COLOR_NO -1.0


//----------------------------------------------------


vec3 getColor(int i)
{
float m;
if (i==-2 ) {return mObj.color; }       
if (i==0 ) {return vec3(0,0,0)/255.0; }
if (i==1 ) {return vec3(255.,255.,255.)/255.0; }
if (i==2 ) {return vec3(255,0,0)/255.0; }
if (i==3 ) {return vec3(0,255,0)/255.0; }
if (i==4 ) {return vec3(0,0,255)/255.0; }
if (i==5 ) {return vec3(255,255,0)/255.0; }
if (i==6 ) {return vec3(0,255,255)/255.0; }
if (i==7 ) {return vec3(255,0,255)/255.0; }
if (i==8 ) {return vec3(192,192,192)/255.0; }
if (i==9 ) {return vec3(128,128,128)/255.0; }
if (i==10 ) {return vec3(128,0,0)/255.0; }
if (i==11 ) {return vec3(128,128,0)/255.0; }
if (i==12 ) {return vec3(0,128,0)/255.0; }
if (i==13 ) {return vec3(128,0,128)/255.0; }
if (i==14 ) {return vec3(0,128,128)/255.0; }
if (i==15 ) {return vec3(0,0,128)/255.0; }    
if (i==16 ) {return vec3(255, 204, 188)/255.0; }
if (i==17 ) {return vec3(0.8, 0.8, 0.8); }
if (i==18 ) {return vec3(0.5, 0.5, 0.8); }
if(i== 19 ) {return vec3(1, 0.5, 0);} 
if(i== 20 ) {return vec3(1.0, 1.0, 1.0);} 
if(i== 21 ) {return vec3(247./255., 168./255.,  184./255.);} 
if(i== 22 ) {return vec3(0, 1, 1);} 
if(i== 23 ) {return vec3(85./255., 205./255., 252./255.);} 
if(i== 24 ) {return  vec3(0.425, 0.56, 0.9)*vec3( 0.3, 0.2, 1.0 );} 
if(i== 25 ) {return vec3(0.8,0.8,0.8)*vec3( 0.3, 0.2, 1.0 ); } 
if(i== 26 ){ return vec3(1.0,0.01,0.01)*vec3( 0.3, 0.2, 1.0 ); } 
if(i== 30 ) { return vec3(0.1, 0.5, 1.0);}   
if(i== 31 ){ return vec3(0.0, 0.6, 0.0);}

}
// end prevoid common --//

//por jorge2017a1-
#define MAX_STEPS 100
#define MAX_DIST 100.
#define MIN_DIST 0.001
#define EPSILON 0.001

vec3 light_pos1   ;
vec3 light_color1 ;
vec3 light_pos2   ;
vec3 light_color2 ;
//operacion de Union
#define opU3(d1, d2) ( d1.x < d2.x ? d1 : d2 )
float sdSphere( vec3 p, float s )
	{ return length(p)-s;}
float sdBox( vec3 p, vec3 b )
	{ vec3 d = abs(p) - b;   return length(max(d,0.0))+ min(max(d.x,max(d.y,d.z)),0.0); }
float sdRoundBox( vec3 p, vec3 b, float r )
	{ vec3 q = abs(p) - b; return length(max(q,0.0)) + min(max(q.x,max(q.y,q.z)),0.0) - r; }
float sdTorus( vec3 p, vec2 t )
	{ vec2 q = vec2(length(p.xz)-t.x,p.y);  return length(q)-t.y; }
float sdCylinder( vec3 p, vec2 h )
	{ vec2 d = abs(vec2(length(p.xz),p.y)) - h; return min(max(d.x,d.y),0.0) + length(max(d,0.0)); }
float sdCylinderYZ( vec3 p, vec2 h )
	{ vec2 d = abs(vec2(length(p.yz),p.x)) - h; return min(max(d.x,d.y),0.0) + length(max(d,0.0)); }
float sdCylinderXZ( vec3 p, vec2 h )
	{ vec2 d = abs(vec2(length(p.xz),p.y)) - h; return min(max(d.x,d.y),0.0) + length(max(d,0.0)); }
float sdCylinderXY( vec3 p, vec2 h )
	{ vec2 d = abs(vec2(length(p.xy),p.z)) - h; return min(max(d.x,d.y),0.0) + length(max(d,0.0)); }

///----------Operacion de Distancia--------
float intersectSDF(float distA, float distB)
	{ return max(distA, distB);}

float unionSDF(float distA, float distB)
	{ return min(distA, distB);}

float differenceSDF(float distA, float distB)
	{ return max(distA, -distB);}
//-------------------------------------------
// object transformation
vec3 rotate_x(vec3 p, float phi)
{
    float c = cos(phi);	float s = sin(phi);
    return vec3(p.x, c*p.y - s*p.z, s*p.y + c*p.z);
}
vec3 rotate_y(vec3 p, float phi)
{
	float c = cos(phi);	float s = sin(phi);
	return vec3(c*p.x + s*p.z, p.y, c*p.z - s*p.x);
}
vec3 rotate_z(vec3 p, float phi)
{
	float c = cos(phi);	float s = sin(phi);
	return vec3(c*p.x - s*p.y, s*p.x + c*p.y, p.z);
}
///------------------------------------
vec2 rotatev2(vec2 p, float ang)
{
    float c = cos(ang);
    float s = sin(ang);
    return vec2(p.x*c - p.y*s, p.x*s + p.y*c);
}

vec3 columna(vec3 p)
{   
    vec3 res;
    
    res = vec3(9999.0, -1.0,-1.0);
    
     float scy1= sdCylinderXZ( p- vec3(0.0,0.0,0.0), vec2(3.5,15.0)  );
    
    float srb1I= sdRoundBox(p-vec3(0.0,-7.5,0.0), vec3(4.5,0.5,4.5), 0.5 );
    float srb2I= sdRoundBox(p-vec3(0.0,-9.5,0.0), vec3(5.0,0.5,5.0), 0.5 );
    float  st1I= sdTorus(p-vec3(0.0,-5.5,0.0), vec2(4.0,0.5) );
    float  st2I= sdTorus(p-vec3(0.0,-6.2,0.0), vec2(4.5,0.5) );
   
    
    float srb1S= sdRoundBox(p-vec3(0.0,15.0,0.0), vec3(5.0,0.5,5.0), 0.5 );
    float srb2S= sdRoundBox(p-vec3(0.0,13.0,0.0), vec3(4.5,0.5,4.5), 0.5 );
    float  st1S= sdTorus(p-vec3(0.0,11.5,0.0), vec2(4.5,0.5) );
    float  st2S= sdTorus(p-vec3(0.0,10.7,0.0), vec2(4.0,0.5) );
    
    //res =opU3(res, vec3(scy1,11.0,MATERIAL_NO)); 
    res =opU3(res, vec3(scy1,-1.0,4.0)); 
    res =opU3(res, vec3(srb1I,12.0,MATERIAL_NO)); 
    res =opU3(res, vec3(srb2I,12.0,MATERIAL_NO)); 
    res =opU3(res, vec3(st1I,13.0,MATERIAL_NO)); 
    res =opU3(res, vec3(st2I,11.0,MATERIAL_NO)); 
    
    res =opU3(res, vec3(srb1S,12.0,MATERIAL_NO)); 
    res =opU3(res, vec3(srb2S,12.0,MATERIAL_NO)); 
    res =opU3(res, vec3(st1S,13.0,MATERIAL_NO)); 
    res =opU3(res, vec3(st2S,11.0,MATERIAL_NO)); 
 	return res;   
}


///------------------------------------
vec3 GetDist(vec3 p  ) 
{	
	vec3 res;
    vec3 pp;
    res = vec3(9999.0, -1.0,-1.0);
    //p= rotate_y(p-vec3(0.0,0.0,0.0), radians(45.0));
	
	float planeDist1 = p.y+0.0;  //piso inf
    res =opU3(res, vec3(planeDist1,-1.0,5.0)); //inf
    p.y=p.y-10.0;
    p.z = abs(mod(p.z, 30.0) - 2.0);
    //p.z=p.z+12.0;

    vec3 q1=p;
    float cx=30.0;
    float cy=11.0;
    float cz=30.0;
   
    q1.x = mod(q1.x+0.5*cx,cx)-0.5*cx;
   	p=q1;
   
    vec3 sc1= columna( p-vec3(0.0,0.0,0.0));
    vec3 sc2= columna( p-vec3(0.0,0.0,30.0));
    
    float srbB1= sdRoundBox(p-vec3(0.0,22.0,15.0), vec3(4.0,6.0,14.5), 0.5 );
    float sdcyB1= sdCylinderYZ(p-vec3(0.0,15.0,15.0), vec2(10.0,5.0 ));
	float dif1= differenceSDF(srbB1, sdcyB1);
  
   
    res =opU3(res, vec3(dif1,3.0,MATERIAL_NO)); 
   
    res =opU3(res, sc1);
    res =opU3(res, sc2);
    
    //res =opU3(res, vec3(1.0,0.0,MATERIAL_NO)); 
    //return (dist, id_color, id_material)
    return res;
}

///-----------------------------------------
vec3 LightShading(vec3 Normal,vec3 toLight,vec3 toEye,vec3 color)
{
    vec3 toReflectedLight=reflect(-toLight, Normal);
    vec3 diffuse = max(0.,dot(Normal,-toLight))*color;
    //vec3 specular = pow(max(0.,dot(Normal,normalize(-toLight-V))),100.)*vec3(1.,1.,1.); 
    float specularf=max(dot(toReflectedLight, toEye),0.0);
    specularf=pow(specularf, 100.0);
    vec3 specular =specularf*vec3(1.0);
    return diffuse + specular;
}
//------------------------------------------------
vec3 GetNormal(vec3 p)
{
	float d = GetDist(p).x;
    vec2 e = vec2(.001, 0);
    vec3 n = d - vec3(
        GetDist(p-e.xyy).x,
        GetDist(p-e.yxy).x,
        GetDist(p-e.yyx).x);
    return normalize(n);
}
//---------actualizacion por Shane---28-may-2020    ...gracias
float RayMarch(vec3 ro, vec3 rd){
    float dO = 0.; 
    vec3 dS=vec3(9999.0,-1.0,-1.0);
    float marchCount = 0.0;
    vec3 p;
    for(int i=0; i<MAX_STEPS; i++) 
    {
    	p = ro + rd*dO;
        dS = GetDist(p);
        if(dO>MAX_DIST || abs(dS.x)<MIN_DIST) break;
        dO += dS.x;
        marchCount++;
    }
    
    mObj.dist = dO;
    mObj.id_color = dS.y;
    mObj.marchCount=marchCount;
    mObj.id_material=dS.z;
    mObj.normal=GetNormal(p);
    return dO;
}

//---------------------------------------------------
float GetShadow(vec3 p, vec3 plig)
{
    vec3 lightPos = plig;
    vec3 l = normalize(lightPos-p);
    vec3 n = GetNormal(p);
    float dif = clamp(dot(n, l), 0., 1.);
    float d = RayMarch(p+n*MIN_DIST*2., l );
    if(d<length(lightPos-p)) dif *= .1;
    return dif;
}
//----------------------------------------------------
//-------------------------------
vec3 Getluz(vec3 p, vec3 ro, vec3 rd, vec3 nor , vec3 colobj ,vec3 plight_pos)
{
    vec3 lightPos = plight_pos;
    float intensity=1.0;
	const float shininess = 64.0;
	vec3 l = normalize( p-lightPos);
    vec3 v = normalize( p-ro);
    vec3 h = normalize(v + l);
    float diff = dot(nor, l);
    
    float occ = 0.5 + 0.5 * nor.y;
    float amb = clamp(0.5 + 0.5 * nor.y, 0.0, 1.0);
    float dif = clamp(dot(l, nor), 0.0, 1.0);
    float spec = pow(clamp(dot(h, nor), 0.0, 1.0), shininess);
    vec3 color = amb * vec3(1.0) * occ;
    color += dif * vec3(1.0) * occ;
    color += dif * spec * vec3(1.0) * occ;
    color=pow( color, vec3(0.1545));
    vec3 result =( LightShading(nor,l,v, colobj))*intensity*color;
    
    
    //vec3 result = LightShading(nor,l,v, colobj)*intensity;
    
    
    if (mObj.blnShadow==true)
    {
    	float fhadow=GetShadow(p,plight_pos);
    	return result*fhadow;
        
        //vec3 psh= p_shadingv3(p,  nor,  ro,  rd,  plight_pos,   colobj );
    	//return result* psh;
     }
    else
    {  return result; }
}
///-------------------------------------
mat2 m = mat2( 0.80,  0.60, -0.60,  0.80 );

float hash( float n )
{
	return fract(sin(n)*43758.5453);
}

float noise( in vec2 x )
{
	vec2 p = floor(x);
	vec2 f = fract(x);
    	f = f*f*(3.0-2.0*f);
    	float n = p.x + p.y*57.0;
    	float res = mix(mix( hash(n+  0.0), hash(n+  1.0),f.x), mix( hash(n+ 57.0), hash(n+ 58.0),f.x),f.y);
    	return res;
}

float fbm( vec2 p )
{
    	float f = 0.0;
    	f += 0.50000*noise( p ); p = m*p*2.02;
    	f += 0.25000*noise( p ); p = m*p*2.03;
    	f += 0.12500*noise( p ); p = m*p*2.01;
    	f += 0.06250*noise( p ); p = m*p*2.04;
    	f += 0.03125*noise( p );
    	return f/0.984375;
}

float thing(vec2 pos) 
{
	vec2 p = pos;
	vec2 offset = vec2(0.0, 1.0);
	float rowX = floor((pos.y)/1.0);
	if (mod(rowX, 2.0) < 1.0)
		offset.x = 0.5 + fbm(p*0.3);
	
	float rowY = floor((pos.y)/1.0);
	if (mod(rowY, 2.0) < 1.0) {
		offset.y = 2.0;
		offset.x = 0.75 * fbm(p*0.5);
		rowX = floor((pos.y)/0.5);
		if (mod(rowX, 2.0) < 1.0)
			offset.x += 0.25 + fbm(p*0.3);
	}
	
	p.x += offset.x;
	float n1 = fbm(pos * 5.0);
	pos.x=fract(pos.x + offset.x * fbm(p*0.9) +.5)-0.5;
	pos.y=fract(pos.y * offset.y +.5)-0.5;
	pos = abs(pos);
   	float a = atan(pos.y, pos.x);
	float b = atan(pos.x, pos.y);
	float n2 = fbm(pos) * (a*b);
	float n3 = n1 * 0.15 / n2 * .75;
	float s = min(pos.x,pos.y) - n3;
	return mix(s, 1.-n1, 0.5);
}

//------------------------------------------------
vec3 getMaterial( vec3 pp, float id_material)
{
  vec3 col=vec3(1.0);
  vec3 p=pp;
    
    
    if (id_material==3.0)
    { 
     vec2 uv =p.xy*0.25;   
     return  thing(uv)*vec3(0.5,1.2,0.5)  ;
    }    
    
    
    if (id_material==4.0)
    { 
     vec2 uv =p.xy*0.25;   
     return  thing(uv)*vec3(1.2,0.2,0.3)  ;
    }    
    
    
    if (id_material==5.0)
    { 
     vec2 uv =p.xz*0.25; //piso   
     return  thing(uv)*vec3(1.0)  ;
    }    
    
    
}
//------------------------------------------------

vec3 GetColorYMaterial(vec3 p,  vec3 n, vec3 ro,  vec3 rd, int id_color, float id_material)
{
   	vec3 colobj; 
    if (id_color<100)
		{ colobj=getColor(int( id_color)); }
    
    
    if (id_material>-1.0 && id_color==-1)
        { 
            colobj=vec3(0.5);
            colobj*=getMaterial(p, id_material); 
            return colobj;
        }
    
    return colobj;
}
///---------------------------------------------
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
   vec2 uv = (gl_FragCoord.xy-.5*iResolution.xy)/iResolution.y;
   mObj.uv=uv;
    float t;
    t=mod(iTime*3.0,360.0);
    itime=t;
	mObj.blnShadow=false;
        
 	light_pos1= vec3(10.0, 6.0, 10.0 );  light_color1 = vec3( 1.0 );
 	light_pos2= vec3( -5.0, 6.0, -5.0 ); light_color2 = vec3( 1.0, 1.0, 1.0 );
 
    
   
    vec3 ro=vec3(15.0,7.0,-25.0+t);
         
    vec3 rd=normalize(vec3(uv,1.0));
    
    
    light_pos1+=ro;
    light_pos2+=ro;
    
    
    vec3 col = vec3(0);
    TObj Obj;
    mObj.rd=rd;
    mObj.ro=ro;
    
    float d = RayMarch(ro, rd);
    Obj=mObj;
    vec3 p = (ro + rd * d ); 
    
    mObj.p=p;
    mObj.dist =d;
    vec3 nor=mObj.normal;

    vec3 colobj;
    colobj=GetColorYMaterial( p, nor, ro, rd,  int( Obj.id_color), Obj.id_material);
    
    
	float dif1=1.0;
   	vec3 result;
    result=  Getluz( p,ro,rd, nor, colobj ,light_pos1);
    result+= Getluz( p,ro,rd, nor, colobj ,light_pos2);
    result/=1.25;
    col= result*dif1;
    
     

  	//sugerencia por dean_the_coder,
    //col *= 1.0 - pow(d / 100.0, 1.5);
    col *= 1.0 - pow(d /(100.0) , 3.0);    
    col = pow(col, vec3(1.0/2.2));  
    gl_FragColor = vec4(col,1.0);
}
